USE [master];
GO


/* 
   Connect on the primary replica
   Configure readonly routes on each replica 
*/
-- First replica
ALTER AVAILABILITY GROUP dummygrp
MODIFY REPLICA ON 'SQL141' WITH
( SECONDARY_ROLE ( READ_ONLY_ROUTING_URL = N'tcp://SQL141.domain.com:1433' ) );

-- Second replica
ALTER AVAILABILITY GROUP dummygrp
MODIFY REPLICA ON 'SQL142' WITH
( SECONDARY_ROLE ( READ_ONLY_ROUTING_URL = N'tcp://SQL142.domain.com:1433' ) );


/* Configure routing list on each replica */
ALTER AVAILABILITY GROUP dummygrp
MODIFY REPLICA ON 'SQL141' WITH
( PRIMARY_ROLE ( READ_ONLY_ROUTING_LIST = ('SQL142', 'SQL143') ) );


ALTER AVAILABILITY GROUP dummygrp
MODIFY REPLICA ON 'SQL142' WITH
( PRIMARY_ROLE ( READ_ONLY_ROUTING_LIST = ('SQL141', 'SQL143') ) );

